local Widget = require"widgets.widget"
local Text = require"widgets.text"
local Image = require"widgets.image"
local monsterutil = require"util.monsterutil"
local biomes = require"defs.biomes"

local Consumable = require "defs.consumable"
-----------------------------------------------------
-- Tooltip for hovering over the upgrade button
-----------------------------------------------------
local LockedEquipmentTooltip = Class(Widget, function(self)
	Widget._ctor(self, "LockedEquipmentTooltip")

	self.bg = self:AddChild(Image("images/ui_ftf_relic_selection/relic_bg_blank.tex"))
		:ApplyMultColor(0, 0, 0, TOOLTIP_BG_ALPHA)

	self.container = self:AddChild(Widget())
	self.title = self.container:AddChild(Text(FONTFACE.DEFAULT, FONTSIZE.SCREEN_SUBTITLE, "title", UICOLORS.LIGHT_TEXT))
		:LeftAlign()
	self.desc = self.container:AddChild(Text(FONTFACE.DEFAULT, FONTSIZE.SCREEN_TEXT, "desc", UICOLORS.LIGHT_TEXT))
		:LeftAlign()
	self.frenzy = self.container:AddChild(Text(FONTFACE.DEFAULT, FONTSIZE.SCREEN_TEXT, STRINGS.UI.ARMORYSCREEN.LOCKED_FRENZY_LVL, UICOLORS.LIGHT_TEXT))
		:LeftAlign()
end)

function LockedEquipmentTooltip:LayoutWithContent( data )
	local item = data.item

	local def = item:GetDef()
	local rarity = def.rarity or "COMMON"
	local item_name = string.format("<#%s>%s</>", rarity, item:GetLocalizedName())
	self.title:SetText(item_name)

	local player = self:GetOwningPlayer()
	local unlocktracker = player.components.unlocktracker
	local can_craft = def.crafting_data.craftable_location
		and (not def.weapon_type
			or unlocktracker:IsWeaponTypeUnlocked(def.weapon_type))
	if can_craft then
		local craftable_location = def.crafting_data.craftable_location[1]
		local location = biomes.locations[craftable_location]

		self.desc:SetText(string.format(STRINGS.UI.ARMORYSCREEN.LOCKED_DESC, location.pretty.name))
	else
		local str = STRINGS.UI.VENDING_MACHINE.WEAPON_LOCKED[def.weapon_type]
		dbassert(str, "Locked equipment without explanation string.")
		self.desc:SetText(str)
	end

	local rarity_id = ITEM_RARITY.id[rarity]

	self.frenzy:SetShown(rarity_id >= ITEM_RARITY.id.EPIC)

	self.container:LayoutChildrenInGrid(1, 10)

	--Equipment.Items[item.slot][item.id]
	local w, h = self.container:GetSize()
	self.bg:SetSize(w+50, h+50)

	self.container:LayoutBounds("center", "center", self.bg)

	return true
end

return LockedEquipmentTooltip
